#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

struct karte {
    int N;
    vector<int> P;
    vector<int> inc;  
    ll cost;          

    karte(int n): N(n), P(n+1), inc(n+1), cost(0) {}

    void init() {
        for(int k = 1; k < N; k++) {
            inc[k] = (P[k+1] == P[k] + 1);
        }
        int segments = 1;
        for(int k = 1; k < N; k++) {
            if(!inc[k]) segments++;
        }
        cost = segments - 1;
    }

    void increment(int k) {
        if(k < 1 || k >= N) return;
        bool now = (P[k+1] == P[k] + 1);
        if(inc[k] != now) {
            if(inc[k]) cost++;  
            else       cost--;  
            inc[k] = now;
        }
    }

    ll pswap(int i, int j) {
        swap(P[i], P[j]);
        for(int k: {i-1, i, j-1, j}) increment(k);
        return cost;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    karte Karte(N);
    for(int i = 1; i <= N; i++) cin >> Karte.P[i];
    Karte.init();

    cout << Karte.cost << '\n';
    while(Q--) {
        int i, j;
        cin >> i >> j;
        cout << Karte.pswap(i, j) << '\n';
    }

    return 0;
}